import { withBemMod } from '@bem-react/core';
import React, { useEffect, useState } from 'react';

import { ILevelLikeYesNo } from 'client/common/types';
import { getCookie, setCookie } from 'utils/cookies';
import { reachGoal } from 'utils/metrika';

import { useComponents } from 'client/common/hooks';

import { b, ILevelProps } from '..';

import './level_type_likeYesNo.css';

export interface ILevelTypeYesNoProps extends Omit<ILevelLikeYesNo, 'type'> {
    type?: 'likeYesNo';
}

export const withLevelTypeLikeYesNo = withBemMod<ILevelTypeYesNoProps, ILevelProps>(
    b(),
    { type: 'likeYesNo' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const {
            question,
            answerYes,
            answerNo,
            metrikaGoal,
            ...otherProps
        } = props;

        const { HtmlContent } = useComponents();

        const cookieName = `yadv-article-vote-${metrikaGoal.paramSlug}`;

        const [nowPlaying, setNowPlaying] = useState('');
        const [answer, setAnswer] = useState('');

        useEffect(() => {
            const currentAnswer = getCookie(cookieName) || '';

            setAnswer(currentAnswer);
        }, [cookieName]);

        const vote = function (newAnswer: string) {
            reachGoal(metrikaGoal.id, {
                slug: metrikaGoal.paramSlug,
                answer: newAnswer
            });

            setAnswer(newAnswer);
            setNowPlaying(newAnswer);
            setCookie(cookieName, newAnswer);
        };

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content')}>
                    <HtmlContent id="question" className={b('question')} content={question} />
                    <div className={b('buttons')}>
                        <button
                            type="button"
                            className={b('button', { pressed: answer === 'yes' })}
                            disabled={Boolean(answer)}
                            onClick={() => {
                                vote('yes');
                            }}
                            >
                            <span>{ answerYes.text }</span>
                            <img
                                alt={answerYes.text}
                                src={nowPlaying === 'yes' ? answerYes.imgGif : answerYes.imgStill}
                                />
                        </button>
                        <button
                            type="button"
                            className={b('button', { pressed: answer === 'no' })}
                            disabled={Boolean(answer)}
                            onClick={() => {
                                vote('no');
                            }}
                            >
                            <span>{ answerNo.text }</span>
                            <img
                                alt={answerNo.text}
                                src={nowPlaying === 'no' ? answerNo.imgGif : answerNo.imgStill}
                                />
                        </button>
                    </div>

                    {answer &&
                        <HtmlContent
                            id="reaction"
                            className={b('reaction')}
                            content={answer === 'no' ? answerNo.reaction : answerYes.reaction}
                            />
                    }
                </div>
            </BaseLevel>
        );
    }
);
