import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelMarkedText } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_markedText.css';

export interface ILevelTypeMarkedTextProps extends Omit<ILevelMarkedText, 'type'> {
    type?: 'markedText';
}

export const withLevelTypeMarkedText = withBemMod<ILevelTypeMarkedTextProps, ILevelProps>(
    b(),
    { type: 'markedText' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { text, className, ...otherProps } = props;
        const { HtmlContent } = useComponents();

        return (
            <BaseLevel className={b({}, [className])} {...otherProps}>
                <div className={b('content')}>
                    <HtmlContent className={b('text')} content={text} />
                </div>
            </BaseLevel>
        );
    }
);
