import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelMarkedText2 } from 'client/common/types';

import { s } from 'utils/findCustomStyle';

import { b, ILevelProps } from '..';

import './level_type_markedText2.css';

export interface ILevelTypeMarkedText2Props extends Omit<ILevelMarkedText2, 'type'> {
    type?: 'markedText2';
}

export const withLevelTypeMarkedText2 = withBemMod<ILevelTypeMarkedText2Props, ILevelProps>(
    b(),
    { type: 'markedText2' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { textBefore, textAfter, texts, title, className, customStyles, ...otherProps } = props;
        const { HtmlContent } = useComponents();

        return (
            <BaseLevel className={b({}, [className])} {...otherProps}>
                <div className={b('content')}>
                    <HtmlContent className={b('content-title')} content={title} />
                    {
                        textBefore &&
                        <div className={b('content-text-single')}>
                            <HtmlContent className={b('text')} content={textBefore} />
                        </div>
                    }
                    {
                        texts.length === 1
                            ? (
                                <div className={b('content-text-single')}>
                                    <HtmlContent className={b('text')} content={texts[0]} />
                                </div>
                            )
                            : (
                                <div className={b('numeric-text-box')}>{
                                    texts.map((text, i) => {
                                        const numText = String(i + 1);

                                        return (
                                            <>
                                                <HtmlContent className={b('content-num')} content={numText} style={s('Bullet', customStyles, ['background', 'color'])} />
                                                <div className={b('content-text')}>
                                                    <HtmlContent className={b('text')} content={text} />
                                                </div>
                                            </>
                                        );
                                    })
                                }
                                </div>
                            )
                    }
                    {
                        textAfter &&
                        <div className={b('content-text-single')}>
                            <HtmlContent className={b('text')} content={textAfter} />
                        </div>
                    }
                </div>
            </BaseLevel>
        );
    }
);
