import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelNote } from 'client/common/types';
import { s } from 'utils/findCustomStyle';

import { b, ILevelProps } from '..';

import './level_type_notes.css';

export interface ILevelTypeNote extends Omit<ILevelNote, 'type'> {
    type?: 'notes';
}

export const withLevelTypeNote = withBemMod<ILevelTypeNote, ILevelProps>(
    b(),
    { type: 'notes' },
    (BaseLevel: React.FC<ILevelProps>) => props => {

        const {
            notes,
            customStyles,
            ...otherProps } = props;

        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div className={b('container')} style={s('Level', customStyles, ['background'])}>
                    {
                        notes.map(({ title, subtitle, body }) => {
                            return (
                                <div key={title} className={b('note-line')}>
                                    <div className={b('badge')}>
                                        <HtmlContent className={b('title')} style={s('Badge', customStyles, ['color'])} content={title} />
                                        <HtmlContent className={b('subtitle-note')} style={s('Badge', customStyles, ['color'])} content={subtitle} />
                                    </div>
                                    <HtmlContent className={b('body')} style={s('Level', customStyles, ['color'])} content={body} />
                                </div>
                            );
                        })
                    }
                </div>
            </BaseLevel>
        );
    }
);
