import { classnames } from '@bem-react/classnames';
import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelQuote } from 'client/common/types';

import { s } from 'utils/findCustomStyle';

import { b, ILevelProps } from '..';

import './level_type_quote.css';

export interface ILevelTypeQuoteProps extends Omit<ILevelQuote, 'type'> {
    type?: 'quote';
}

export const withLevelTypeQuote = withBemMod<ILevelTypeQuoteProps, ILevelProps>(
    b(),
    { type: 'quote' },
    (BaseLevel: React.FC<ILevelProps>) => props => {

        const { imageSrc, name, info, text, customStyles, className: baseClassName, ...otherProps } = props;

        const levelTypeQuoteMods = imageSrc ? {} : { image: 'no' };
        const className = classnames(
            baseClassName,
            b('', levelTypeQuoteMods)
        );

        const { HtmlContent } = useComponents();

        return (
            <BaseLevel className={className} {...otherProps}>
                <div
                    className={b('content')}
                    style={s('Level', customStyles, ['background'])}
                    >
                    <div className={b('human')}>
                        {imageSrc && (
                            <img className={b('human-photo')} src={imageSrc} alt={name} />
                        )}
                        <div className={b('human-info')}>
                            <div className={b('human-name')} title={name} style={s('Level', customStyles, ['color'])}>{name}</div>
                            <HtmlContent className={b('human-description')} style={s('Level', customStyles, ['color'])} content={info} />
                        </div>
                    </div>
                    <HtmlContent className={b('text')} tag="div" content={text} style={s('Level', customStyles, ['color'])} />
                </div>
            </BaseLevel>
        );
    }
);
