import { Enhance, withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelResults } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_results.css';

export interface ILevelTypeResultsProps extends Omit<ILevelResults,
    | 'type'> {
    type?: 'results';
    imageHeight?: number;
}

export const LevelTypeResults: React.FC<ILevelTypeResultsProps
    & { BaseLevel: React.FC<ILevelProps> }>
    = props => {
        const {
            contentTitle,
            results,
            name,
            tag,
            imageHeight,
            BaseLevel,
            ...otherProps } = props;

        const resultsMod = { size: results.length };
        const { HtmlContent } = useComponents();
        const height = imageHeight && imageHeight > 0 ? imageHeight : undefined;

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content')}>
                    <div className={b('head')}>
                        {name && <div className={b('name')}>{name}</div>}
                        {tag && <div className={b('tag')}>{tag}</div>}
                    </div>
                    <HtmlContent
                        className={b('content-title')}
                        content={contentTitle}
                        />
                    <div className={b('results', resultsMod)}>{
                        results.map(({ title, imageSrc, description }) => (
                            <div key={title} className={b('result')}>
                                <div className={b('result-image')}>
                                    <img src={imageSrc} alt={title} height={height} />
                                </div>
                                <HtmlContent
                                    className={b('result-title')}
                                    content={title}
                                    />
                                <HtmlContent
                                    className={b('result-description')}
                                    content={description}
                                    />
                            </div>
                        ))}
                    </div>
                </div>
            </BaseLevel>
        );
    };

export const withLevelTypeResults = (enhance: Enhance<ILevelTypeResultsProps & ILevelProps>) =>
    withBemMod<ILevelTypeResultsProps, ILevelProps>(
        b(),
        { type: 'results' },
        enhance
    );
