import { Enhance, withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelResults2 } from 'client/common/types';
import { s } from 'utils/findCustomStyle';

import { b, ILevelProps } from '..';

import './level_type_results2.css';

export interface ILevelTypeResults2Props extends Omit<ILevelResults2,
    | 'type'> {
    type?: 'results2';
}

export const LevelTypeResults2: React.FC<ILevelTypeResults2Props
    & { BaseLevel: React.FC<ILevelProps> }>
    = props => {
        const {
            contentTitle,
            companyTitle,
            footerText,
            results,
            rows,
            customStyles,
            mapItemsByRows,
            BaseLevel,
            ...otherProps } = props;

        const resultsMod = { size: results.length, compact: props.compact };
        const { HtmlContent } = useComponents();

        const byRows = mapItemsByRows(results, rows);

        return (
            <BaseLevel {...otherProps}>
                <div className={`${b('content')} ${b(props.compact ? 'compact_content' : '')}`} style={s('Level', customStyles, ['background'])}>
                    {companyTitle && <HtmlContent
                        className={b('company-title')}
                        content={companyTitle}
                        style={s('Level', customStyles, ['color'])}
                        />}
                    <HtmlContent
                        className={b('content-title')}
                        content={contentTitle}
                        style={s('Level', customStyles, ['color'])}
                        />
                    <div className={b('results2', resultsMod)}>{
                        byRows.map(row => (
                            <div key={row.row.key || '0'} className={b('result-row')}>
                                {row.results.map(({ title, imageSrc, description }) => (
                                    <div key={title} className={b('result')}>
                                        <div style={s('Badge', customStyles, ['background'])} className={b('result-card', { results: props.compact ? 'compact' : row.results.length })}>
                                            <img src={imageSrc} alt={title} className={b('result-image')} />
                                            <HtmlContent
                                                className={b('result-title')}
                                                content={title}
                                                style={s('Badge', customStyles, ['color'])}
                                                />
                                            <HtmlContent
                                                className={b('result-description')}
                                                content={description}
                                                style={s('Badge', customStyles, ['color'])}
                                                />
                                        </div>
                                    </div>
                                ))}
                            </div>
                        ))}
                    </div>
                    {footerText && <HtmlContent
                        className={b('footer-text')}
                        content={footerText}
                        style={s('Level', customStyles, ['color'])}
                        />}
                </div>
            </BaseLevel>
        );
    };

export const withLevelTypeResults2 = (enhance: Enhance<ILevelTypeResults2Props & ILevelProps>) =>
    withBemMod<ILevelTypeResults2Props, ILevelProps>(
        b(),
        { type: 'results2' },
        enhance
    );
