import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelResumeLines } from 'client/common/types';

import { s } from 'utils/findCustomStyle';

import { b, ILevelProps } from '..';

import './level_type_resume_lines.css';

export interface ILevelTypeAboutResumeLines extends Omit<ILevelResumeLines, 'type'> {
    type?: 'resumeLines';
}

export const withLevelTypeResumeLines = withBemMod<ILevelTypeAboutResumeLines, ILevelProps>(
    b(),
    { type: 'resumeLines' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { title, lines, image, customStyles, ...otherProps } = props;

        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div className={b('container')} style={s('Level', customStyles, ['background'])}>
                    <div className={b('text')}>
                        <h2
                            className={b('title')}
                            style={s('Level', customStyles, ['color'])}
                            >
                            {title}
                        </h2>
                        <ul className={b('items')} >
                            {lines.map(line => (
                                <li key={line} className={b('item')} style={s('Level', customStyles, ['color'])}>
                                    <HtmlContent
                                        className={b('text-item')}
                                        content={line}
                                        style={s('Level', customStyles, ['color'])}
                                        />
                                </li>
                            ))}
                        </ul>
                    </div>
                    <div className={b('img-container')}>
                        <img className={b('img')} src={image} />
                    </div>
                </div>
            </BaseLevel>
        );
    }
);
