import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ISolutionHeader } from 'client/common/types';

import { b, ILevelProps } from '..';

export interface ILevelTypeSolutionHeaderProps extends Omit<ISolutionHeader, 'type'> {
    type?: 'solutionHeader';
}

export const withLevelTypeSolutionHeader = withBemMod<ILevelTypeSolutionHeaderProps, ILevelProps>(
    b(),
    { type: 'solutionHeader' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { solutionTitle, solutionSubtitle, image, ...otherProps } = props;

        const { SolutionHeader } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <SolutionHeader title={solutionTitle} description={solutionSubtitle} imgTitle={image} />
            </BaseLevel>
        );
    }
);
