import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelSolutionRecommendations } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_solution_recommendations.css';

export interface ILevelTypeSolutionRecommendations extends Omit<ILevelSolutionRecommendations, 'type'> {
    type?: 'solutionRecommendations';
}

export const withLevelTypeSolutionRecommendations = withBemMod<ILevelTypeSolutionRecommendations, ILevelProps>(
    b(),
    { type: 'solutionRecommendations' },
    (BaseLevel: React.FC<ILevelProps>) => props => {

        const { recommendations, ...otherProps } = props;
        const { HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content_recomendation')}>
                    {recommendations.map((item, index) => (
                        <div key={item} className={b('info')}>
                            <span className={b('number-item')}> {index + 1 >= 10 ? index + 1 : `0${index + 1}`} </span>
                            <HtmlContent className={b('info-section')} content={item} />
                        </div>
                    ))}
                </div>
            </BaseLevel>
        );
    }
);
