import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { IStructuredInfo } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_structured_info.css';

export interface ILevelTypeStructuredInfoProps extends Omit<IStructuredInfo, 'type'> {
    type?: 'structuredInfo';
}

export const withLevelTypeStructuredInfo = withBemMod<ILevelTypeStructuredInfoProps, ILevelProps>(
    b(),

    { type: 'structuredInfo' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { cards, footer, ...otherProps } = props;
        const { HtmlContent, CardContainer, CardInformation } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content')}>
                    <CardContainer>
                        { cards.map(card => (<CardInformation key={card.title} {...card} />)) }
                    </CardContainer>
                    <HtmlContent className={b('footer')} content={footer} />
                </div>
            </BaseLevel>
        );
    }
);
