import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';

import { IExtendedImage } from 'client/common/components/extended-image/ExtendedImage.type';
import { ILevelMedia } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_thumb.css';

export interface ILevelTypeThumbProps extends Omit<ILevelMedia, 'type'> {
    extendedImage?: IExtendedImage;
    type?: 'thumb';
}

/* eslint-disable complexity */
export const withLevelTypeThumb = withBemMod<ILevelTypeThumbProps, ILevelProps>(
    b(),
    { type: 'thumb' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { textAlign, contentDescription, blocks, ...otherProps } = props;
        const { HtmlContent, ExtendedImage } = useComponents();
        const blocksExist = blocks && blocks.length > 0;

        const imageSrc = blocksExist && blocks[0].image;
        const extendedImage = blocksExist && blocks[0].extendedImage;
        const alignMod = textAlign ? { align: textAlign } : {};

        const caption = extendedImage && blocksExist ? blocks[0].caption : '';

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content', alignMod)}>
                    {contentDescription && (
                        <HtmlContent
                            className={b('content-description')}
                            content={contentDescription}
                            />
                    )}
                    { imageSrc && <img className={b('image')} src={imageSrc} /> }
                    {
                        !imageSrc && extendedImage &&
                        <ExtendedImage extendedImage={extendedImage} caption={caption} className={b('image')} />
                    }
                </div>
            </BaseLevel>
        );
    }
);
