import { withBemMod } from '@bem-react/core';
import React from 'react';

import { useComponents } from 'client/common/hooks';
import { ILevelVideo } from 'client/common/types';

import { b, ILevelProps } from '..';

import './level_type_video.css';

export interface ILevelTypeVideoProps extends Omit<ILevelVideo, 'type'> {
    type?: 'video';
}

export const withLevelTypeVideo = withBemMod<ILevelTypeVideoProps, ILevelProps>(
    b(),
    { type: 'video' },
    (BaseLevel: React.FC<ILevelProps>) => props => {
        const { videoSrc, caption, ...otherProps } = props;

        const { VideoIframe, HtmlContent } = useComponents();

        return (
            <BaseLevel {...otherProps}>
                <div className={b('content')}>
                    <VideoIframe className={b('video')} videoSrc={videoSrc} />
                    {caption && <HtmlContent className={b('caption')} content={caption} />}
                </div>
            </BaseLevel>
        );
    }
);
