import React, { PropsWithChildren } from 'react';

import { useComponents } from 'client/common/hooks';
import { IBaseLevel } from 'client/common/types';

import { b, ILevelProps } from './index';

function Level({
    key,
    innerRef,
    className,
    children,
    title,
    subtitle,
    description,
    enabledTouchAdaptiveIframe,
    compact,
    compactOrder
}: PropsWithChildren<ILevelProps> & IBaseLevel) {
    const { HtmlContent } = useComponents();

    return (
        <div
            key={key}
            ref={innerRef}
            className={b({}, [className, b('', { compact, order: compactOrder })])}
            >
            {title && (
                <h2
                    className={b('title')}
                    dangerouslySetInnerHTML={{ __html: title }}
                    />
            )}
            {subtitle && (
                <h3
                    className={b('subtitle')}
                    dangerouslySetInnerHTML={{ __html: subtitle }}
                    />
            )}
            {description && (
                <HtmlContent
                    className={b('description')}
                    enabledTouchAdaptiveIframe={enabledTouchAdaptiveIframe}
                    content={description}
                    />
            )}
            {children}
        </div>
    );
}

export default Level;
