import { classnames } from '@bem-react/classnames';
import React from 'react';

import cn from 'utils/cn';

import './index.css';

export const cnLogo = cn('logo');

interface ILogoProps {
    className?: string;
    colored?: boolean;
    language: string;
    url: string;
    service?: 'direct';
}

function Logo({ className = '', colored, language, url, service }: ILogoProps) {
    const lang = ['en', 'tr', 'zh-Hans'].indexOf(language) > -1 ? 'en' : 'ru';

    return <a className={classnames(cnLogo({ lang, colored, service }), className)} href={url} />;
}

export default Logo;
