import React, { ReactNode } from 'react';

import { useComponents } from 'client/common/hooks';

import './index.css';

import cn from 'utils/cn';

const b = cn('main-layout');

interface IMainLayoutProps {
    children: ReactNode;
}

function MainLayout({ children }: IMainLayoutProps) {
    return (
        <section className={b()}>
            <div className={b('wrapper')}>
                {children}
            </div>
        </section>
    );
}

interface IMainLayoutTitleProps {
    children: string;
}

function MainLayoutTitle({ children }: IMainLayoutTitleProps) {
    return <h2 className={b('title')} dangerouslySetInnerHTML={{ __html: children }} />;
}

interface IMainLayoutDescriptionProps {
    children: string;
}

function MainLayoutDescription({ children }: IMainLayoutDescriptionProps) {
    const { HtmlContent } = useComponents();

    return <HtmlContent className={b('description')} content={children} />;
}

interface IMainLayoutColumnsProps {
    children: ReactNode;
    transparent?: boolean;
}

function MainLayoutColumns({ children, transparent }: IMainLayoutColumnsProps) {
    return (
        <div className={b('columns', { transparent })}>
            {children}
        </div>
    );
}

interface IMainLayoutContentProps {
    children: ReactNode;
}

function MainLayoutContent({ children }: IMainLayoutContentProps) {
    return (
        <article className={b('content')}>
            {children}
        </article>
    );
}

MainLayout.Columns = MainLayoutColumns;
MainLayout.Content = MainLayoutContent;
MainLayout.Description = MainLayoutDescription;
MainLayout.Title = MainLayoutTitle;

export default MainLayout;
