import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';

import { ISideMenu } from 'client/common/types';
import { IAppState } from 'store';
import { toggleSidebar } from 'store/sidebar/actions';
import { TSidebarAction } from 'store/sidebar/types';

import MainMenu from './mainMenu';

interface IDispatchProps {
    toggleSidebar(): void;
}

interface IStateProps {
    isOpen: boolean;
    menuIndexChain: number[];
}

interface IOwnProps {
    hasSearch: boolean;
    siteSearchUrl?: string;
    menu: ISideMenu;
    scrollableHead?: boolean;
}

type TMainMenuProps = IOwnProps & IStateProps;

function mapStateToProps(state: IAppState, ownProps: IOwnProps): TMainMenuProps {
    const { isOpen, menuIndexChain } = state.sidebar;

    return {
        hasSearch: ownProps.hasSearch,
        siteSearchUrl: ownProps.siteSearchUrl,
        menu: ownProps.menu,
        scrollableHead: ownProps.scrollableHead,
        isOpen,
        menuIndexChain
    };
}

function mapDispatchToProps(dispatch: Dispatch<TSidebarAction>): IDispatchProps {
    return bindActionCreators({
        toggleSidebar
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(MainMenu);
