import React, { Fragment } from 'react';
import Helmet from 'react-helmet';

import { IAppData } from 'client/common/types';

import MetaOg from './og';
import MetaSeo from './seo';

const MOBILE_VIEW_PORT = 'width=device-width,minimum-scale=1,' +
    'maximum-scale=1,initial-scale=1,user-scalable=no';

interface IMetaProps extends Pick<IAppData, 'seo' | 'og' | 'uatraits'>{}

function Meta({ uatraits, seo, og }: IMetaProps) {
    return (
        <Fragment>
            <Helmet>
                <meta
                    name="viewport"
                    content={uatraits.isMobile ? MOBILE_VIEW_PORT : ''}
                    />
            </Helmet>
            <MetaSeo seo={seo} />
            <MetaOg og={og} />
        </Fragment>
    );
}

export default Meta;
