import React from 'react';
import Helmet from 'react-helmet';

import { IAppData } from 'client/common/types';

interface IMetaOgProps extends Pick<IAppData, 'og'>{}

function MetaOg({ og }: IMetaOgProps) {
    return (
        <Helmet>
            <meta property="og:title" content={og && og.title} />
            <meta property="og:description" content={og && og.description} />
            <meta property="og:image" content={og && og.image} />
        </Helmet>
    );
}

export default MetaOg;
