import React from 'react';
import Helmet from 'react-helmet';

import { IAppData } from 'client/common/types';

import { useConfig } from 'client/common/hooks';
import { replaceHtmlEntities } from 'utils/helper';

interface IMetaSeoProps extends Pick<IAppData, 'seo'>{}

function MetaSeo({ seo }: IMetaSeoProps) {
    const { htmlMappings } = useConfig();
    const titleTemplate = seo?.titleTemplate && replaceHtmlEntities(htmlMappings, seo.titleTemplate).replace(/({{param}})/g, '%s');
    const pageTitle = seo?.pageTitle && replaceHtmlEntities(htmlMappings, seo.pageTitle);
    const defaultTitle = seo?.title && replaceHtmlEntities(htmlMappings, seo.title);

    return (
        <Helmet titleTemplate={titleTemplate} defaultTitle={defaultTitle}>
            <title>{titleTemplate ? pageTitle : defaultTitle}</title>
            <meta name="description" content={seo && seo.description} />
            <meta name="keywords" content={seo && seo.keywords} />
        </Helmet>
    );
}

export default MetaSeo;
