import React, { ReactNode } from 'react';

import cn from 'utils/cn';

import './index.css';

const b = cn('modal-content');

interface IModalContentProps {
    children?: ReactNode;
    onCloseClick: () => void;
    title: string;
}

function ModalContent({ children, onCloseClick, title }: IModalContentProps) {
    return (
        <div className={b()}>
            <div className={b('close')} onClick={onCloseClick} />
            <div className={b('content')}>
                <div className={b('title')}>
                    {title}
                </div>
                {children}
            </div>
        </div>
    );
}

export default ModalContent;
