import React, { useEffect, useRef } from 'react';

import { OverlayScrollProps } from './OverlayScroll.types';

export default function OverlayScroll({ children, className }: OverlayScrollProps) {
    const ref = useRef<HTMLDivElement>(null);

    useEffect(() => {
        if (ref.current !== null) {
            const scrollbarWidth = ref.current.offsetWidth - ref.current.clientWidth;
            const scrollbarHeight = ref.current.offsetHeight - ref.current.clientHeight;

            ref.current.style.marginBottom = `${-scrollbarHeight}px`;
            ref.current.style.marginRight = `${-scrollbarWidth}px`;
        }
    }, [ref]);

    return (
        <div className={className} ref={ref}>
            { children }
        </div>
    );
}
