import React, { Fragment } from 'react';

import { ICommonPlatformAttributeProps } from './PlatformWrapper.type';

function PlatformWrapper(props: ICommonPlatformAttributeProps) {

    const { component: Child, platform, platformProps, fixedProps } = props;

    const readyPropsForChild = { ...fixedProps };

    platformProps.forEach(item => {
        const value = item.platforms[platform] || item.platforms.common;

        readyPropsForChild[item.name] = value;
    });

    return (
        <Fragment>
            <Child {...readyPropsForChild} />
        </Fragment>
    );
}

export default PlatformWrapper;
