import ZoomableImage, { IZoomableImageProps } from 'client/common/components/zoomable-image';

type Platform = 'desktop' | 'touch' | 'common';

export interface IPlatformSrc {
    name: 'src';
    platforms: {
        [platform in Platform]: string;
    };
}

type TWrappedComponentsProps = IZoomableImageProps;

export type IPlatformAttribute = IPlatformSrc;

export interface IPlatformAttributeProps {
    platformProps: IPlatformAttribute[];
    fixedProps: TWrappedComponentsProps;
    component: typeof ZoomableImage;
}

export interface ICommonPlatformAttributeProps extends IPlatformAttributeProps {
    platform: Platform;
}
