import React, { useRef } from 'react';

import { useDispatch } from 'react-redux';
import { setContainerRef } from 'store/popups/actions';
import { TContainerRef } from 'store/popups/types';

import cn from 'utils/cn';

import './index.css';

const b = cn('popups-container');

interface IPopupsContainerProps {
    className?: string;
}

function PopupsContainer({ className }: IPopupsContainerProps) {
    const ref: TContainerRef = useRef<HTMLDivElement>(null);
    const dispatch = useDispatch();

    return (
        <div
            className={b({}, [className])}
            ref={element => {
                ref.current = element;

                dispatch(setContainerRef(ref));
            }}
            />
    );
}

export default PopupsContainer;
