import React from 'react';

import { useComponents } from 'client/common/hooks';

import { IPost } from 'client/common/types';

import cn from 'utils/cn';

const b = cn('post-card');

interface IPostCardProps {
    className?: string;
    post: IPost;
    url: string;
    mark?: string;
    cardType?: string;
    isDatesHidden?: boolean;
}

function PostCard({
    className = '',
    post,
    url,
    mark,
    cardType,
    isDatesHidden
}: IPostCardProps) {
    const { approvedTitle, publishDate } = post;
    const { Card } = useComponents();

    return (
        <Card
            classNames={[b(), className]}
            view="agency"
            title={approvedTitle}
            url={url}
            date={publishDate}
            mark={mark}
            cardType={cardType}
            isDatesHidden={isDatesHidden}
            />
    );
}

export default PostCard;
