import React from 'react';

import { IPrefooterSection } from 'client/common/types';
import cn from 'utils/cn';

import './index.css';

export interface IPrefooterProps {
    sections: IPrefooterSection[];
    renderSections: (sections: IPrefooterSection[]) => JSX.Element[];
}

export const cnPrefooter = cn('prefooter');

function Prefooter({ sections, renderSections }: IPrefooterProps) {
    return (
        <section className={cnPrefooter()}>
            <div className={cnPrefooter('wrapper')}>
                <div className={cnPrefooter('data')}>
                    {renderSections(sections)}
                </div>
            </div>
        </section>
    );
}

export default Prefooter;
