import React from 'react';

import { cnPrefooter } from 'client/common/components/prefooter';
import { useLegoComponents } from 'client/common/hooks';

interface IPrefooterItemProps {
    url: string;
    name: string;
}

function PrefooterItem({ url, name }: IPrefooterItemProps) {
    const { Link } = useLegoComponents();

    return (
        <div className={cnPrefooter('item')}>
            <Link theme="black" href={url}>{name}</Link>
        </div>
    );
}

export default PrefooterItem;
