import { ItemSimple } from '@yandex-lego/components/Menu';
import React, { ChangeEvent } from 'react';

import { useLegoComponents } from 'client/common/hooks';
import { TRegion } from 'client/common/types';

import cn from 'utils/cn';

import './index.css';

export interface IRegionSwitcherProps {
    className?: string;
    hasFlags?: boolean;
    tld: string;
    regions: TRegion[];
}

const b = cn('region-switcher');

function RegionSwitcher({
    className = '',
    hasFlags = false,
    tld,
    regions
}: IRegionSwitcherProps) {
    const { Select } = useLegoComponents();

    function wrapRegion({ url, name, tld: regionTld }: TRegion) {
        const mods = hasFlags ?
            { flag: regionTld.replace('.', '-'), 'pad-left': true } :
            {};

        return {
            value: url,
            content: <span key={name} className={b('text', mods)}>{name}</span>
        };
    }

    function handleChange(event: ChangeEvent<HTMLSelectElement>) {
        window.location.assign(event.target.value);
    }

    const currentName = regions.find(region => region.tld === tld)!.name;
    const options = [
        regions
            .filter(({ name }) => name !== currentName)
            .reduce((acc, region) => {
                acc.items = acc.items.concat(wrapRegion(region));

                return acc;
            }, { title: '', items: [] as ItemSimple[] })
    ];

    const placeholder = hasFlags ? ' ' : currentName;

    const mods: {[key: string]: string | boolean} = { 'has-flags': hasFlags };

    if (mods['has-flags']) {
        mods.flag = tld.replace('.', '-');
    }

    return (
        <div className={b(mods, [className])}>
            <Select
                size="m"
                theme="normal"
                placeholder={placeholder}
                onChange={handleChange}
                options={options}
                />
        </div>
    );
}

export default RegionSwitcher;
