import { ITextinputProps } from '@yandex-lego/components/Textinput';
import React, { FormEventHandler, ReactNode } from 'react';

import { useLegoComponents } from 'client/common/hooks';

import cn from 'utils/cn';

import './index.css';

export interface ISearchProps extends Omit<ITextinputProps, 'type'> {
    siteSearchUrl?: string;
    hidden?: boolean;
    addonInside?: ReactNode;
    addonBefore?: ReactNode;
    onSubmit?: FormEventHandler;
}

export const b = cn('search');

function Search({ className, hidden, addonInside, addonBefore, onSubmit, ...props }: ISearchProps) {
    const { Textinput } = useLegoComponents();

    const { controlRef, value, placeholder, onKeyDown, onChange, onFocus, onBlur } = props;

    return (
        <form className={b({}, [className])} onSubmit={onSubmit}>
            { addonBefore }
            <div style={{ opacity: Number(!hidden) }} className={b('input', [className])}>
                <Textinput
                    value={value as string}
                    placeholder={placeholder}
                    theme="normal"
                    size="m"
                    controlRef={controlRef}
                    hasClear
                    onKeyDown={onKeyDown}
                    onChange={onChange}
                    onFocus={onFocus}
                    onBlur={onBlur}
                    />
                { addonInside }
            </div>
        </form>
    );
}

export default Search;
