import { connect } from 'react-redux';

import { IAppState } from 'store';

import SidebarPusher from './sidebar-pusher';

interface IStateProps {
    pushed: boolean;
}

function mapStateToProps(state: IAppState): IStateProps {
    const { isOpen } = state.sidebar;

    return {
        pushed: isOpen
    };
}

export default connect<IStateProps>(
    mapStateToProps
)(SidebarPusher);
