import React, { ReactNode, useEffect, useState } from 'react';

import cn from 'utils/cn';

import './index.css';

const cnSidebar = cn('sidebar-pusher');

interface ISidebarPusher {
    children: ReactNode;
    pushed: boolean;
}

function SidebarPusher({ children, pushed }: ISidebarPusher) {
    // Чтобы контент не "плавал" инициализируемся без модификаторов, а потом меняем на нужный
    const [mod, setMod] = useState({});

    useEffect(() => {
        setMod(pushed ? { pushed: 'yes' } : { pushed: 'no' });
    }, [pushed]);

    return (
        <div className={cnSidebar(mod)}>
            {children}
        </div>
    );
}

export default SidebarPusher;
