import { connect } from 'react-redux';

import { bindActionCreators, Dispatch } from 'redux';
import { IAppState } from 'store';
import { popMenuItem, pushMenuItem } from 'store/sidebar/actions';
import { TSidebarAction } from 'store/sidebar/types';

import Sidebar from './sidebar';

function mapStateToProps(state: IAppState) {
    const { isOpen, menuIndexChain } = state.sidebar;

    return { isOpen, menuIndexChain };
}

function mapDispatchToProps(dispatch: Dispatch<TSidebarAction>) {
    return bindActionCreators({
        pushMenuItem,
        popMenuItem
    }, dispatch);
}

export type ISidebarStateProps = ReturnType<typeof mapStateToProps>;
export type ISidebarDispatchProps = ReturnType<typeof mapDispatchToProps>;

export default connect(
    mapStateToProps,
    mapDispatchToProps
)(Sidebar);
