import React, { MouseEvent } from 'react';

import { useConfig } from 'client/common/hooks';
import { IMenuItem } from 'client/common/types';
import { addMenuParam } from 'utils/mainMenu';

import { b } from '../sidebar';

interface ISidebarMenuItemProps {
    item: IMenuItem;
    index: number;
    onItemClick: (index: number) => void;
}

function SidebarMenuItem({ item, index, onItemClick }: ISidebarMenuItemProps) {
    const hasItems = item.items && item.items.length;
    const { uatraits } = useConfig();

    return (
        <a
            className={b('item', { current: item.isCurrent })}
            onClick={onClick}
            href={item.url}
            >
            {hasItems && <div className={b('arrow')} />}
            <span dangerouslySetInnerHTML={{ __html: item.title }} />
        </a>
    );

    function onClick(e: MouseEvent) {
        if (!uatraits.isMobile && item.switchToSectionPage) {
            e.preventDefault();

            onItemClick(index);

            window.location.assign(addMenuParam(item.url, true));
        }
    }
}

export default SidebarMenuItem;
