import React from 'react';

import { ILink } from 'client/common/types';
import cn from 'utils/cn';
import i18n from 'utils/i18n';

import './index.css';

interface ISocialProps {
    socialLinks: ILink[];
}

const cnSocial = cn('social');
const cnItem = (name: string) => cnSocial('item', { name });

function Social({ socialLinks }: ISocialProps) {
    return (
        <div className={cnSocial()}>
            {socialLinks.map(({ name, url }) => {
                const title = i18n({
                    keyset: 'common',
                    key: name
                });

                return (
                    <a
                        key={name}
                        title={title}
                        href={url} target="_blank"
                        className={cnItem(name)}
                        rel="noopener noreferrer"
                        />
                );
            })}
        </div>
    );
}

export default Social;
