import React from 'react';

import cn from 'utils/cn';

import { useComponents } from 'client/common/hooks';

import { s, TCustomStyle } from 'utils/findCustomStyle';

import './SolutionHeader.css';

const solutH = cn('solution-header');

interface ISolutionHeader {
    title: string;
    description: string;
    imgTitle?: string;
    customStyles?: TCustomStyle[];
}
const SolutionHeader = function (props: ISolutionHeader) {
    const { title, description, imgTitle, customStyles } = props;
    const { HtmlContent } = useComponents();

    return (
        <div className={solutH('header-block')} style={s('Header', customStyles, ['background'])}>
            <div className={solutH('titles-block')}>
                <h1 className={solutH('content-title')} style={s('Header', customStyles, ['color'])}> {title} </h1>
                <HtmlContent className={solutH('content-subtitle')} style={s('Header', customStyles, ['color'])} content={description} />
            </div>
            <div className={solutH('subimg')}>
                {imgTitle && <img className={solutH('image')} src={imgTitle} />}
            </div>
        </div>
    );
};

export default SolutionHeader;
