import React, { ChangeEvent } from 'react';

import { useLegoComponents } from 'client/common/hooks';

import cn from 'utils/cn';

import './index.css';

const b = cn('underscored-input');

interface IUnderscoredInput {
    size?: 's' | 'm';
    placeholder?: string | undefined;
    value?: string | undefined;
    className?: string | undefined;
    onChange?: ((event: ChangeEvent<HTMLInputElement>) => void) | undefined;
}

export default function UnderscoredInput({
    placeholder,
    value,
    size = 's',
    className,
    onChange
}: IUnderscoredInput) {
    const { Textinput } = useLegoComponents();
    const hasValue = Boolean(value);

    return (
        <div className={b({ size, 'has-value': hasValue }, [className])}>
            <span className={b('space-holder')}>{value || placeholder}</span>
            <div className={b('input')}>
                <Textinput
                    theme="normal"
                    size="s"
                    placeholder={placeholder}
                    value={value}
                    onChange={onChange}
                    />
            </div>
        </div>
    );
}
