import React from 'react';

import cn from 'utils/cn';

import './index.css';

interface IVideIframeProps {
    className?: string;
    videoSrc: string;
}

const b = cn('video-iframe');

function VideoIframe({ className, videoSrc }: IVideIframeProps) {
    return (
        <div className={b({}, [className])}>
            <iframe
                src={videoSrc}
                frameBorder={0}
                scrolling="no"
                allowFullScreen
                />
        </div>
    );
}

export default VideoIframe;
