import { Component, createElement } from 'react';

import { scriptPath } from './constants';
import init from './init';

export type TMetrikaVersion = '1' | '2';

interface IMetrikaOptions {
    [key: string]: {
        webvisor: boolean
        clickmap: boolean;
        trackLinks: boolean;
        accurateTrackBounce: boolean;
    };
}

interface IMetrika {
    accounts: number[];
    options?: IMetrikaOptions;
    version?: TMetrikaVersion;
}

class YMInitializer extends Component<IMetrika> {
    insertPoint: HTMLElement;

    componentDidMount() {
        const { options = {}, version = '2', accounts } = this.props;

        init(accounts, options, version);

        const el = document.createElement('script');

        el.type = 'text/javascript';
        el.async = true;
        el.src = scriptPath(version);

        this.insertPoint.insertBefore(el, null);
    }

    render() {
        const setInsertPoint = (element: HTMLElement) => {
            this.insertPoint = element;
        };

        return createElement(
            'div',
            { ref: setInsertPoint }
        );
    }
}

export { YMInitializer, IMetrika, IMetrikaOptions };
