import { TMetrikaVersion } from './component';

const accountListName = 'adv_yandex_metrika_accounts';

function callbackQueueName(version: TMetrikaVersion) {
    if (version === '1') {
        return 'yandex_metrika_callbacks';
    }

    return 'yandex_metrika_callbacks2';
}

function scriptPath(version: TMetrikaVersion) {
    if (version === '1') {
        return 'https://mc.yandex.ru/metrika/watch.js';
    }

    return 'https://mc.yandex.ru/metrika/tag.js';
}

function trackerConstructorName(version: TMetrikaVersion) {
    if (version === '1') {
        return 'Metrika';
    }

    return 'Metrika2';
}

function trackerInstanceName(id: number) {
    return `yaCounter${id}`;
}

function trackerVersionName(id: number) {
    return `yaCounterVersion${id}`;
}

export {
    accountListName,
    callbackQueueName,
    scriptPath,
    trackerConstructorName,
    trackerInstanceName,
    trackerVersionName
};
