// форк библиотеки react-yandex-metrika
// https://github.com/narkq/react-yandex-metrika
// поддержка различных опций для разных счетчиков
// tslint:disable:no-any

import {
    accountListName,
    callbackQueueName,
    trackerInstanceName,
    trackerVersionName
} from './constants';

declare global {
    interface Window {
        [accountListName]: number[];
        'yandex_metrika_callbacks': any[];
        'yandex_metrika_callbacks2': any[];
        Ya: any;
    }
}

function ymProxy(id: number, methodName: any, ...args: any[]) {
    try {
        (window as any)[trackerInstanceName(id)][methodName](...args);
    } catch (ex) {
        console.warn(ex);
    }
}

function accountIdList() {
    return typeof window === 'undefined' ? [] : window[accountListName] || [];
}

function ymAsyncProxy(ids: number[]) {
    return function (...args: any[]) {
        ids.forEach(id => {
            const trackerVersion = (window as any)[trackerVersionName(id)];
            const callbackQueue = window[callbackQueueName(trackerVersion)];

            if (callbackQueue) {
                // @ts-ignore
                callbackQueue.push(() => ymProxy(id, ...args));
            } else {
                // @ts-ignore
                ymProxy(id, ...args);
            }
        });
    };
}

function ym(...args: any[]) {
    return ymAsyncProxy(accountIdList())(...args);
}

export function withId(counterId: any) {
    return withFilter((id: any) => counterId === id);
}

export function withFilter(f: any) {
    return ymAsyncProxy(accountIdList().filter(f));
}

export default ym;
export { YMInitializer, IMetrika, IMetrikaOptions } from './component';
// tslint:enable:no-any
