import { IMetrikaOptions, TMetrikaVersion } from './component';
import {
    accountListName,
    callbackQueueName,
    trackerConstructorName,
    trackerInstanceName,
    trackerVersionName
} from './constants';

export default function init(
    accounts: number[],
    options: IMetrikaOptions = {},
    version: TMetrikaVersion
) {
    const callbackQueue = callbackQueueName(version);

    window[accountListName] = window[accountListName] || [];
    for (const account of accounts) {
        if (window[accountListName].indexOf(account) === -1) {
            window[accountListName].push(account);
        }
    }
    window[callbackQueue] = window[callbackQueue] || [];
    window[callbackQueue].push(() => {
        accounts.forEach(id => {
            const defaultOptions = { id };
            const accountOptions = options[id] || {};

            // tslint:disable:no-any
            try {
                (window as any)[trackerInstanceName(id)] = new window
                    .Ya[trackerConstructorName(version)]({ ...defaultOptions, ...accountOptions });
            } catch (ex) {
                console.warn(ex);
            }
        });
    });

    accounts.forEach(id => {
        (window as any)[trackerVersionName(id)] = version;
    });
    // tslint:enable:no-any
}
