import { Layer, Map, Placemark, withYmaps } from '@yandex-int/ymaps-react';
import React from 'react';

import './index.css';

import cn from 'utils/cn';

const b = cn('ymap');

interface IProps {
    className?: string;
    coordinates: [number, number];
    provider: 'yandex' | 'osm';
    zoom: number;
}

function YMap({ className, coordinates, provider, zoom }: IProps) {
    const providerIsYandex = provider === 'yandex';
    const mapType = providerIsYandex ? 'yandex#map' : new ymaps.MapType('empty', []);

    return (
        <Map
            behaviors={['drag', 'scrollZoom', 'dblClickZoom', 'rightMouseButtonMagnifier']}
            center={coordinates}
            className={b({}, [className])}
            type={mapType}
            zoom={zoom}
            >
            <Placemark
                geometry={{ type: 'Point', coordinates }}
                options={{ preset: 'islands#redDotIcon' }}
                />
            {!providerIsYandex && (
                <Layer
                    tileUrlTemplate="https://a.tile.openstreetmap.org/%z/%x/%y.png"
                    options={{ projection: ymaps.projection.sphericalMercator }}
                    />
            )}
        </Map>
    );
}

export default withYmaps(YMap);
