import React, { useEffect, useState } from 'react';
import cn from 'utils/cn';
import './ZoomableImage.css';

type TCssProperty = string | number;

export interface IZoomableImageProps {
    zoomAllow?: boolean;
    caption?: string;
    src?: string;
    className?: string;
    style?: {
        width?: TCssProperty;
        height?: TCssProperty;
    };
}

function ZoomableImage({ zoomAllow, caption, src, className, style }: IZoomableImageProps) {

    const [isOpenImg, setIsOpenImg] = useState(false);

    function manageImg() {
        setIsOpenImg(!isOpenImg);
    }

    useEffect(() => {
        window.document.body.style.overflowY = isOpenImg ? 'hidden' : 'scroll';
    });

    let extendedImgClass = isOpenImg ? 'zoomable-img-open' : 'zoomable-img-close';

    extendedImgClass = zoomAllow ? extendedImgClass : className || 'zoomable-img';

    const cnExtendedImg = cn(extendedImgClass);

    style = isOpenImg ? {} : style;

    return (
        <div className={`${cnExtendedImg()} ${className}`} style={style} >
            {
                zoomAllow ?
                    <div className={cnExtendedImg('container')} onClick={manageImg} style={style}>
                        <div className={cnExtendedImg('wrapper')} style={style}>
                            {
                                isOpenImg && <button className={cnExtendedImg('close-button')} />

                            }
                            <img className={className} src={src} style={style} />
                            {
                                isOpenImg && caption &&
                                <div className={cnExtendedImg('caption')}> {caption} </div>
                            }
                        </div>
                    </div> :
                    <img src={src} />
            }
        </div>
    );
}

export default ZoomableImage;
