import React, { createContext, ReactNode } from 'react';

import { ICommonData } from 'client/common/types';

interface ICommonDataProviderProps {
    children: ReactNode;
    data: {
        commonData: ICommonData
    };
}

export const CommonDataContext = createContext<ICommonData>({} as ICommonData);

export function CommonDataContextProvider({ children, data }: ICommonDataProviderProps) {
    return (
        <CommonDataContext.Provider value={data.commonData}>
            {children}
        </CommonDataContext.Provider>
    );
}
