import React, { createContext, ReactNode, useMemo } from 'react';

import { IConfigData } from 'client/common/types/config';

export const ConfigContext = createContext<IConfigData>({
    avatarsHost: '',
    contactFormPath: '',
    homeUrl: '',
    htmlMappings: {},
    language: '',
    mordaHost: '',
    passportHost: '',
    secretKey: '',
    agenciesConfig: {
        groupsByCountryGeoId: {},
        agency: {
            logo: {
                default: ''
            },
            description: {
                maxPreviewLength: 0,
                maxLength: 0
            }
        }
    },
    tld: '',
    url: '',
    uatraits: {
        isMobile: false
    }
});

interface IConfigContextProviderProps {
    children: ReactNode;
    data: IConfigData;
}

export function ConfigContextProvider({ children, data }: IConfigContextProviderProps) {
    const config = {
        avatarsHost: '',
        contactFormPath: data.contactFormPath,
        homeUrl: data.homeUrl,
        htmlMappings: data.htmlMappings,
        language: data.language,
        mordaHost: data.mordaHost,
        passportHost: data.passportHost,
        secretKey: data.secretKey,
        agenciesConfig: data.agenciesConfig,
        tld: data.tld,
        uatraits: data.uatraits,
        url: data.url
    };
    const configContextValue = useMemo(() => config, [config]);

    return (
        <ConfigContext.Provider value={configContextValue}>
            {children}
        </ConfigContext.Provider>
    );
}
