import React, { createContext, ReactNode } from 'react';

import { IAppData } from 'client/common/types';

export const SettingsContext = createContext<IAppData['settings']>({
    footer: {
        metrikaGoalId: '',
        phone: '',
        socialLinks: [],
        text: ''
    }
});

interface ISettingsContextProviderProps {
    children: ReactNode;
    data: IAppData;
}

export function SettingsContextProvider({ children, data }: ISettingsContextProviderProps) {
    return (
        <SettingsContext.Provider value={data.settings}>
            {children}
        </SettingsContext.Provider>
    );
}
