import React, { createContext, ReactNode, useMemo } from 'react';

import { IAppData } from 'client/common/types';

interface IUserContextProviderProps {
    children: ReactNode;
    data: IAppData;
}

export const UserContext = createContext<IAppData['userInfo']>({});

export function UserContextProvider({ children, data }: IUserContextProviderProps) {
    const userContextValue = useMemo(() => data.userInfo, [data.userInfo]);

    return (
        <UserContext.Provider value={userContextValue}>
            {children}
        </UserContext.Provider>
    );
}
