import { useSelector } from 'react-redux';

import { IAgenciesFilters } from 'client/common/types';

import { IAppState } from 'store';
import { IAgenciesState, TAgenciesFilters } from 'store/agencies/types';

export function useAgenciesFilters(): TAgenciesFilters {
    return useSelector<IAppState, TAgenciesFilters>(state => state.agencies.filters);
}

export function useAgenciesRawFilters(): IAgenciesFilters {
    return useSelector<IAppState, IAgenciesFilters>(state => state.agencies.rawFilters);
}

export function useAgencies(): IAgenciesState {
    return useSelector<IAppState, IAgenciesState>(state => state.agencies);
}
