import React, { ComponentType } from 'react';
import { useSelector } from 'react-redux';

import { IAppState } from 'store';

export function useMenuOpen() {
    return useSelector<IAppState, boolean>(state => state.sidebar.isOpen);
}

interface IWithMenuOpenProps {
    isMenuOpen: ReturnType<typeof withMenuOpen>;
}

export function withMenuOpen<T extends IWithMenuOpenProps>(Component: ComponentType<T>) {
    return function Wrapped(props: Omit<T, 'isMenuOpen'>) {
        const isMenuOpen = useMenuOpen();

        return <Component isMenuOpen={isMenuOpen} {...props as T} />;
    };
}
